// priority: 9
let 伤害事件模块配置 = {
    调试日志: false,
    检测半径: 128
};

let 事件列表 = [
    "net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent",
    "top.theillusivec4.curios.api.event.CurioChangeEvent",
];

let 套装加成调试 = (消息) => {
    if (伤害事件模块配置.调试日志) {
        console.log("[套装加成调试]", 消息);
    }
}

let 飞行标记 = "kjs_fly";
let 玩家激活套装数据 = "player_set";

let 检查并移除不合规饰品 = (p) => {
    let 饰品主处理器结果 = $饰品.getCuriosInventory(p);
    if (!饰品主处理器结果) return;
    let 饰品处理器选项 = 饰品主处理器结果.resolve();
    if (!饰品处理器选项.isPresent()) return;
    let 饰品真实处理器 = 饰品处理器选项.get();
    let 物品集合处理器 = 饰品真实处理器.getEquippedCurios();
    let 已装备ID列表 = [];
    for (let 索引 = 0; 索引 < 物品集合处理器.getSlots(); 索引++) {
        let 物品堆栈 = 物品集合处理器.getStackInSlot(索引);
        if (物品堆栈 && !物品堆栈.isEmpty()) {
            已装备ID列表.push(物品堆栈.id);
        }
    }
    for (let 索引 = 0; 索引 < 物品集合处理器.getSlots(); 索引++) {
        let 物品堆栈 = 物品集合处理器.getStackInSlot(索引);
        if (物品堆栈.isEmpty()) continue;
        let 当前饰品ID = 物品堆栈.id;
        global.自定义盔甲套装.forEach(套装 => {
            if (!套装.饰品 || !Array.isArray(套装.饰品)) return;
            套装.饰品.forEach(条件 => {
                if (typeof 条件 === "object" && 条件 !== null && 条件.id === 当前饰品ID) {
                    if (条件.前置饰品) {
                        let 前置列表 = Array.isArray(条件.前置饰品) ? 条件.前置饰品 : [条件.前置饰品];
                        if (!前置列表.every(前置ID => 已装备ID列表.includes(前置ID))) {
                            let 卸下的物品 = 物品堆栈.copy();
                            物品集合处理器.setStackInSlot(索引, $物品堆栈.EMPTY);
                            p.give(卸下的物品);
                            p.tell(`由于缺少前置饰品，${卸下的物品.displayName.string} §c已被自动卸下！`);
                        }
                    }
                    if (条件.互斥饰品) {
                        let 互斥列表 = Array.isArray(条件.互斥饰品) ? 条件.互斥饰品 : [条件.互斥饰品];
                        if (互斥列表.some(互斥ID => 已装备ID列表.includes(互斥ID) && 互斥ID !== 当前饰品ID)) {
                            let 卸下的物品 = 物品堆栈.copy();
                            物品集合处理器.setStackInSlot(索引, $物品堆栈.EMPTY);
                            p.give(卸下的物品);
                            p.tell(`由于排斥冲突，${卸下的物品.displayName.string} §c已被自动卸下！`);
                        }
                    }
                }
            });
        });
    }
};

let 激活的套装列表 = (p) => {
    if (!p || !(p instanceof $玩家) || p.isFake() || !p.server) return [];
    if (!global.自定义盔甲套装 || !Array.isArray(global.自定义盔甲套装)) return [];
    let 头盔ID = p.headArmorItem ? p.headArmorItem.id : null;
    let 胸甲ID = p.chestArmorItem ? p.chestArmorItem.id : null;
    let 裤衩ID = p.legsArmorItem ? p.legsArmorItem.id : null;
    let 靴子ID = p.feetArmorItem ? p.feetArmorItem.id : null;
    let 主手ID = p.mainHandItem ? p.mainHandItem.id : null;
    let 副手ID = p.offHandItem ? p.offHandItem.id : null;
    let 已装备饰品列表 = [];
    let 饰品主处理器结果 = $饰品.getCuriosInventory(p);
    if (饰品主处理器结果) {
        let 饰品处理器选项 = 饰品主处理器结果.resolve();
        if (饰品处理器选项.isPresent()) {
            let 饰品真实处理器 = 饰品处理器选项.get();
            let 物品集合处理器 = 饰品真实处理器.getEquippedCurios();
            for (let 索引 = 0; 索引 < 物品集合处理器.getSlots(); 索引++) {
                let 物品堆栈 = 物品集合处理器.getStackInSlot(索引);
                if (物品堆栈 && !物品堆栈.isEmpty()) {
                    已装备饰品列表.push(物品堆栈.id);
                }
            }
        }
    }
    let 计算后激活的套装结果 = [];
    global.自定义盔甲套装.forEach(套装 => {
        if (!套装.套装内部名称) return;
        let 套装是否激活 = true;
        if (套装.部件) {
            if (套装.部件.头盔 && 头盔ID !== 套装.部件.头盔) 套装是否激活 = false;
            if (套装是否激活 && 套装.部件.胸甲 && 胸甲ID !== 套装.部件.胸甲) 套装是否激活 = false;
            if (套装是否激活 && 套装.部件.裤衩 && 裤衩ID !== 套装.部件.裤衩) 套装是否激活 = false;
            if (套装是否激活 && 套装.部件.靴子 && 靴子ID !== 套装.部件.靴子) 套装是否激活 = false;
            if (套装是否激活 && 套装.部件.主手 && 主手ID !== 套装.部件.主手) 套装是否激活 = false;
            if (套装是否激活 && 套装.部件.副手 && 副手ID !== 套装.部件.副手) 套装是否激活 = false;
        }
        if (套装是否激活 && 套装.饰品) {
            let 饰品需求满足 = false;
            if (typeof 套装.饰品 === "string") {
                饰品需求满足 = 已装备饰品列表.includes(套装.饰品);
            } else if (Array.isArray(套装.饰品)) {
                if (套装.饰品.length === 0) {
                    饰品需求满足 = true;
                } else {
                    饰品需求满足 = 套装.饰品.every(function (条件) {
                        if (typeof 条件 === "string") return 已装备饰品列表.includes(条件);
                        if (Array.isArray(条件)) return 条件.some(选项ID => 已装备饰品列表.includes(选项ID));
                        if (typeof 条件 === "object" && 条件 !== null && 条件.id) {
                            if (条件.count) {
                                return 已装备饰品列表.filter(id => id === 条件.id).length >= 条件.count;
                            }
                            return 已装备饰品列表.includes(条件.id);
                        }
                        return false;
                    });
                }
            }
            if (!饰品需求满足) 套装是否激活 = false;
        }
        if (套装是否激活) 计算后激活的套装结果.push(套装);
    });
    return 计算后激活的套装结果;
};

let 附近最高难度 = (附近玩家, sDATA) => {
    let 优先级难度 = 难度标签键名数组.slice().reverse();
    for (let 期望难度 of 优先级难度) {
        let 完整阶段名 = 难度阶段前缀 + 期望难度;
        for (let 单个玩家 of 附近玩家) {
            if (单个玩家.stages && typeof 单个玩家.stages.has === "function" && 单个玩家.stages.has(完整阶段名)) {
                return 期望难度;
            }
        }
    }
    if (sDATA.contains("游戏难度")) {
        let 服务器设定难度 = sDATA.getString("游戏难度");
        if (难度标签键名数组.includes(服务器设定难度)) {
            return 服务器设定难度;
        }
    }
    return 默认难度;
};

let 判定附近最高动态阶段 = (附近玩家, sDATA) => {
    for (let 目标阶段名 of 动态阶段优先级) {
        for (let 单个玩家 of 附近玩家) {
            let pDATA = 单个玩家.persistentData;
            let 玩家动态难度启用 = true;
            let 全局强制动态难度 = sDATA.contains("globalDynamicDifficultyForce") ? sDATA.getBoolean("globalDynamicDifficultyForce") : false;

            if (全局强制动态难度) {
                玩家动态难度启用 = sDATA.contains("globalDynamicDifficultyForceState") ? sDATA.getBoolean("globalDynamicDifficultyForceState") : false;
            } else if (pDATA.contains("dynamicDifficultyEnabled")) {
                玩家动态难度启用 = pDATA.getBoolean("dynamicDifficultyEnabled");
            }

            if (玩家动态难度启用 && 单个玩家.stages && typeof 单个玩家.stages.has === "function" && 单个玩家.stages.has(目标阶段名)) {
                return 目标阶段名;
            }
        }
    }
    return null;
};

let 检查目标是否匹配 = (受击者, 条件列表) => {
    if (!条件列表 || 条件列表.length === 0) return true;
    for (let 单个条件 of 条件列表) {
        switch (单个条件.toLowerCase()) {
            case "怪物": if (受击者 instanceof $怪物) return true; break;
            case "友好": if (受击者 instanceof $动物 || 受击者 instanceof $环境生物 || 受击者 instanceof $村民基类) return true; break;
            case "玩家": if (受击者 instanceof $玩家) return true; break;
            default: if ($注册中心.ENTITY_TYPES.getKey(受击者.getType()).toString() === 单个条件) return true; break;
        }
    }
    return false;
};

let 获取伤害源MsgId = (伤害源) => {
    if (伤害源 && typeof 伤害源.getType === "function") {
        return 伤害源.getType();
    }
    return "未知伤害源";
};

事件列表.forEach(字符串 => {
    let 类 = Java.loadClass(字符串);
    NativeEvents.onEvent(类, e => {
        let p = e.getEntity ? e.getEntity() : (e.getPlayer ? e.getPlayer() : (e.getLivingEntity ? e.getLivingEntity() : (e.entity || e)));
        if (!(p instanceof $玩家) || p.isFake() || !p.server) return;
        检查并移除不合规饰品(p);
        let 实际激活套装ID = 激活的套装列表(p).map(套装 => 套装.套装内部名称);
        let pDATA = p.persistentData;
        let 实际激活套装JSON = JSON.stringify(实际激活套装ID);
        if (pDATA.getString(玩家激活套装数据) !== 实际激活套装JSON) {
            pDATA.putString(玩家激活套装数据, 实际激活套装JSON);
        }
    });
});

NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.living.LivingAttackEvent"), e => {
    let 伤害源 = e.getSource();
    let 受击者 = e.getEntity();
    if (!伤害源 || !受击者) return;

    let 实际攻击者 = 伤害源.getActual();
    let 当前伤害源ID = 获取伤害源MsgId(伤害源);

    if (实际攻击者 instanceof $玩家 && !实际攻击者.isFake() && 受击者 instanceof $生物实体) {
        let 攻击者pDATA = 实际攻击者.persistentData;
        if (攻击者pDATA.contains(玩家激活套装数据)) {
            let 攻击者激活的套装ID = [];
            try { 攻击者激活的套装ID = JSON.parse(攻击者pDATA.getString(玩家激活套装数据)); } catch (err) { return; }

            if (攻击者激活的套装ID.length > 0) {
                for (let 套装ID of 攻击者激活的套装ID) {
                    let 单个套装配置 = global.自定义盔甲套装.find(s => s.套装内部名称 === 套装ID);
                    if (!单个套装配置 || !单个套装配置.攻击附加效果 || !Array.isArray(单个套装配置.攻击附加效果)) continue;
                    for (let 附加效果 of 单个套装配置.攻击附加效果) {
                        if ((附加效果.概率 === undefined || Math.random() < 附加效果.概率) && 检查目标是否匹配(受击者, 附加效果.目标条件)) {
                            let 效果类型 = $注册中心.MOB_EFFECTS.getValue(new $资源位置(附加效果.效果ID));
                            if (效果类型) 受击者.addEffect(new $药水效果实例(效果类型, 附加效果.时长 * 20, 附加效果.等级, false, 附加效果.显示粒子));
                        }
                    }
                }
            }
        }
    }

    if (受击者 instanceof $玩家 && !受击者.isFake() && 受击者.isAlive()) {
        if (当前伤害源ID === "未知伤害源") return;
        let 受击者pDATA = 受击者.persistentData;
        if (受击者pDATA.contains(玩家激活套装数据)) {
            let 受击者激活的套装ID = [];
            try { 受击者激活的套装ID = JSON.parse(受击者pDATA.getString(玩家激活套装数据)); } catch (err) { return; }
            if (受击者激活的套装ID.length > 0) {
                for (let 套装ID of 受击者激活的套装ID) {
                    let 单个套装配置 = global.自定义盔甲套装.find(s => s.套装内部名称 === 套装ID);
                    if (!单个套装配置 || !单个套装配置.免疫伤害列表 || !Array.isArray(单个套装配置.免疫伤害列表)) continue;
                    for (let 免疫规则 of 单个套装配置.免疫伤害列表) {
                        if (免疫规则 === "全部伤害") {
                            套装加成调试(`[AttackEvent] 完全免疫触发! 玩家 "${受击者.name.string}" 因套装 "${套装ID}" 免疫了所有伤害.`);
                            e.setCanceled(true);
                            return;
                        }
                        if (typeof 免疫规则 !== "string") continue;
                        let 配置期望的ID = (伤害ID中文名映射表[免疫规则] || 免疫规则);
                        if (当前伤害源ID.toLowerCase() === 配置期望的ID.toLowerCase()) {
                            套装加成调试(`[AttackEvent] 完全免疫触发! 玩家 "${受击者.name.string}" 免疫了 "${当前伤害源ID}" 攻击.`);
                            e.setCanceled(true);
                            return;
                        }
                    }
                }
            }
        }
    }
});

NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.living.LivingHurtEvent"), e => {
    let 实体 = e.getEntity();
    let 原伤害 = e.getAmount();
    if (原伤害 <= 0) return;

    if (实体 instanceof $玩家 && !实体.isFake() && 实体.isAlive()) {
        let 受击者pDATA = 实体.persistentData;
        if (受击者pDATA.contains(玩家激活套装数据)) {
            let 受击者激活的套装ID = [];
            try { 受击者激活的套装ID = JSON.parse(受击者pDATA.getString(玩家激活套装数据)); } catch (err) { return; }

            if (受击者激活的套装ID.length > 0) {
                let 计算后伤害 = 原伤害;
                let 当前伤害源ID = 获取伤害源MsgId(e.getSource());
                受击者激活的套装ID.forEach(套装ID => {
                    let 单个套装配置 = global.自定义盔甲套装.find(s => s.套装内部名称 === 套装ID);

                    if (!单个套装配置 || !单个套装配置.免疫伤害列表 || !Array.isArray(单个套装配置.免疫伤害列表)) return;
                    for (let 免疫规则 of 单个套装配置.免疫伤害列表) {
                        if (typeof 免疫规则 !== "object" || 免疫规则 === null) continue;
                        for (let 规则键 in 免疫规则) {
                            let 调整系数 = Number(免疫规则[规则键]);

                            if (isNaN(调整系数)) continue;
                            if (规则键 === "全部伤害") {
                                计算后伤害 *= 调整系数;
                            } else {
                                let 期望伤害ID = (typeof 伤害ID中文名映射表 !== "undefined" && 伤害ID中文名映射表[规则键]) || 规则键;
                                if (当前伤害源ID.toLowerCase() === 期望伤害ID.toLowerCase()) {
                                    计算后伤害 *= 调整系数;
                                }
                            }
                        }
                    }
                });
                if (Math.abs(计算后伤害 - 原伤害) > 0.001) {
                    e.setAmount(计算后伤害 < 0 ? 0 : 计算后伤害);
                }
            }
        }
    }

    let 实际攻击者 = e.getSource().getActual();
    if (实际攻击者 && 实际攻击者.isLiving() && !(实际攻击者 instanceof $玩家)) {
        let 计算后伤害 = e.getAmount();
        if (计算后伤害 <= 0) return;

        let s = 实际攻击者.level.server;
        let sDATA = s.persistentData;
        let 检测区域 = 实际攻击者.getBoundingBox().inflate(伤害事件模块配置.检测半径);
        let 区域内所有实体 = 实际攻击者.level.getEntitiesWithin(检测区域);
        let 附近玩家 = [];
        if (区域内所有实体) {
            附近玩家 = 区域内所有实体.filter(p => (p instanceof $玩家) && !p.isSpectator() && p.isAlive());
        }

        if (附近玩家.length > 0) {
            let 有效难度标识 = 附近最高难度(附近玩家, sDATA);
            let 有效动态阶段名 = 判定附近最高动态阶段(附近玩家, sDATA);
            let 总伤害调整倍率 = 1.0;
            let 攻击者ID = String(实际攻击者.type);
            let 特定生物基础伤害倍率 = 1.0;

            if (typeof 生物强化全局配置 !== "undefined") {
                if (生物强化全局配置.生物定制配置 && 生物强化全局配置.生物定制配置[攻击者ID] && 生物强化全局配置.生物定制配置[攻击者ID].属性列表 && typeof 生物强化全局配置.生物定制配置[攻击者ID].属性列表.伤害 === "number") {
                    特定生物基础伤害倍率 = 生物强化全局配置.生物定制配置[攻击者ID].属性列表.伤害;
                } else if (生物强化全局配置.生物影响白名单 && 生物强化全局配置.生物影响白名单[攻击者ID] && typeof 生物强化全局配置.生物影响白名单[攻击者ID].伤害 === "number") {
                    特定生物基础伤害倍率 = 生物强化全局配置.生物影响白名单[攻击者ID].伤害;
                }
            }
            总伤害调整倍率 *= 特定生物基础伤害倍率;
            let 难度倍率 = 1.0;
            if (typeof 难度属性定义 !== "undefined" && 难度属性定义[有效难度标识] && typeof 难度属性定义[有效难度标识].伤害 === "number") {
                难度倍率 = 难度属性定义[有效难度标识].伤害;
            }
            总伤害调整倍率 *= 难度倍率;
            let 动态阶段倍率 = 1.0;
            if (有效动态阶段名 && typeof 动态阶段强化效果 !== "undefined" && 动态阶段强化效果[有效动态阶段名] && 动态阶段强化效果[有效动态阶段名].属性列表 && typeof 动态阶段强化效果[有效动态阶段名].属性列表.伤害 === "number") {
                动态阶段倍率 = 动态阶段强化效果[有效动态阶段名].属性列表.伤害;
            }
            总伤害调整倍率 *= 动态阶段倍率;

            if (总伤害调整倍率 !== 1.0) {
                计算后伤害 *= 总伤害调整倍率;
            }
        }

        if (Math.abs(计算后伤害 - e.getAmount()) > 0.001) {
            e.setAmount(计算后伤害 < 0 ? 0 : 计算后伤害);
        }
    }
});

NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.living.MobEffectEvent$Applicable"), e => {
    let p = e.getEntity();
    if (!(p instanceof $玩家) || !p || p.isFake() || (p.level && p.level.isClientSide())) {
        return;
    }
    let 当前激活的套装列表 = 激活的套装列表(p);
    if (!当前激活的套装列表 || 当前激活的套装列表.length === 0) {
        return;
    }
    let 动态免疫效果ID集合 = new Set();
    当前激活的套装列表.forEach(激活套装 => {
        if (激活套装 && 激活套装.免疫效果列表) {
            if (!Array.isArray(激活套装.免疫效果列表)) return;
            激活套装.免疫效果列表.forEach(免疫ID => {
                if (typeof 免疫ID === "string") {
                    动态免疫效果ID集合.add(免疫ID.trim());
                }
            });
        }
    });
    if (动态免疫效果ID集合.size === 0) {
        return;
    }
    let 将要应用的效果实例 = e.getEffectInstance();
    if (!将要应用的效果实例) return;
    let 药水效果类型 = 将要应用的效果实例.getEffect();
    if (!药水效果类型) return;
    let 效果ID = String($注册中心.MOB_EFFECTS.getKey(药水效果类型));
    if (动态免疫效果ID集合.has(效果ID)) {
        e.setResult("deny");
    }
});

PlayerEvents.tick(e => {
    let p = e.player;
    if (!p || !p.server || p.isFake() || !(p instanceof $玩家)) {
        return;
    }

    if (p.age % 20 !== 0) {
        return;
    }

    let pDATA = p.persistentData;
    let 应激活的套装ID = [];
    let 玩家字符串 = "";

    if (pDATA.contains(玩家激活套装数据)) {
        let JAVA字符串 = pDATA.getString(玩家激活套装数据);
        if (JAVA字符串 !== null && typeof JAVA字符串 !== "undefined") {
            玩家字符串 = String(JAVA字符串);
        }
    }

    if (玩家字符串 && 玩家字符串.length > 0) {
        try {
            应激活的套装ID = JSON.parse(玩家字符串);
        } catch (err) {
            应激活的套装ID = [];
        }
    }
    global.自定义盔甲套装.forEach(定义的套装配置 => {
        if (!定义的套装配置.套装内部名称 || !定义的套装配置.效果列表 || !Array.isArray(定义的套装配置.效果列表)) return;
        let 此套装是否激活 = 应激活的套装ID.includes(定义的套装配置.套装内部名称);
        定义的套装配置.效果列表.forEach(效果项 => {
            if (效果项.类型 === "属性" && 效果项.uuid && 效果项.作用属性) {
                let 目标属性 = $注册中心.ATTRIBUTES.getValue(new $资源位置(效果项.作用属性));
                if (!目标属性) return;
                let 属性实例 = p.getAttribute(目标属性);
                if (!属性实例) return;
                let 修改器唯一标识符 = $唯一标识符.fromString(效果项.uuid);
                if (此套装是否激活) {
                    if (!属性实例.getModifier(修改器唯一标识符)) {
                        let 修改器名称 = 效果项.效果显示名称 || `套装加成: ${定义的套装配置.套装内部名称} - ${效果项.作用属性}`;
                        let 计算操作 = 操作映射[效果项.计算操作];
                        if (!计算操作) return;
                        let 修改器 = new $属性修改器(修改器唯一标识符, 修改器名称, 效果项.数值, 计算操作);
                        属性实例.addPermanentModifier(修改器);
                    }
                } else {
                    if (属性实例.getModifier(修改器唯一标识符)) {
                        属性实例.removeModifier(修改器唯一标识符);
                    }
                }
            }
        });
    });

    应激活的套装ID.forEach(套装ID => {
        let 激活套装配置 = global.自定义盔甲套装.find(s => s.套装内部名称 === 套装ID);
        if (激活套装配置 && 激活套装配置.效果列表 && Array.isArray(激活套装配置.效果列表)) {
            激活套装配置.效果列表.forEach(效果项 => {
                if (效果项.类型 === "药水" && 效果项.药水ID) {
                    let 目标药水效果 = $注册中心.MOB_EFFECTS.getValue(new $资源位置(效果项.药水ID));
                    if (!目标药水效果) return;
                    let 等级 = 效果项.等级 || 0;
                    let 时长 = (typeof 效果项.时长 === "number" && 效果项.时长 > 0) ? 效果项.时长 : 2;
                    p.addEffect(new $药水效果实例(目标药水效果, 时长 * 20, 等级, false, true, true));
                }
            });
        }
    });

    let 玩家飞行权限 = false;
    应激活的套装ID.forEach(套装ID => {
        let 激活套装配置 = global.自定义盔甲套装.find(s => s.套装内部名称 === 套装ID);
        if (激活套装配置 && 激活套装配置.飞行能力 && Array.isArray(激活套装配置.飞行能力) && 激活套装配置.飞行能力.includes("开启")) {
            玩家飞行权限 = true;
        }
    });

    let 能力 = p.getAbilities();
    let 更新能力 = false;
    let 套装是否曾赋予飞行 = pDATA.getBoolean(飞行标记);

    if (玩家飞行权限) {
        if (!能力.mayfly) {
            能力.mayfly = true;
            更新能力 = true;
            套装加成调试(`[飞行能力] -> 决定: 赋予[${p.name.string}]飞行许可 (mayfly=true)`);
        }

        更新能力 = true;

        if (!套装是否曾赋予飞行) {
            pDATA.putBoolean(飞行标记, true);
        }

    } else {
        if (套装是否曾赋予飞行 && !(能力.instabuild) && !p.isSpectator()) {
            if (能力.mayfly) {
                能力.mayfly = false;
                if (能力.flying) {
                    能力.flying = false;
                }
                更新能力 = true;
            }
        }
        if (套装是否曾赋予飞行) {
            pDATA.putBoolean(飞行标记, false);
        }
    }

    if (更新能力) {
        套装加成调试(`[飞行能力] -> 操作: [${p.name.string}]的能力需要同步，发送更新包。`);
        p.onUpdateAbilities();
    }
});